/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminCommon;
import filenet.vw.toolkit.admin.result.VWAdminConfirmDialog;
import filenet.vw.toolkit.admin.result.VWAdminConfirmWithCheckBoxDialog;
import filenet.vw.toolkit.admin.result.VWAdminErrorDataObj;
import filenet.vw.toolkit.admin.result.VWAdminErrorsDialog;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminResultTableModelBase;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

public class VWAdminLockWork {
    private boolean m_bCanceled = false;
    private boolean m_bOverride = false;
    private Vector m_vErrors = new Vector();
    private VWAdminResultPane m_resultsPane;
    private VWTable m_resultsTable;
    private int[] m_selectedRows;
    private VWAdminResultTableModelBase m_tableModel;
    private Vector m_wobsList = new Vector();
    private VWParticipant m_logonUser = null;
    private Frame m_parentFrame = null;
    private Container m_mainContainer = null;
    private ListSelectionModel m_listSelectionModel = null;
    private int m_modelColIndex;
    private String m_colName;
    private Vector v_values = new Vector();

    public VWAdminLockWork(VWAdminResultPane resultsPane, String dlgTitle, String msg, String checkBoxMsg) {
        this.init(resultsPane);
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_lockWorkDialogTitle, 1, null);
            this.m_bCanceled = true;
            return;
        }
        this.buildWobsList(this.m_selectedRows);
        if (VWAdminCommon.isAllLockedByCurrentUser(this.m_wobsList)) {
            this.removeReferences();
            return;
        }
        if (VWAdminCommon.isAnyLockedByOthers(this.m_wobsList)) {
            VWAdminConfirmWithCheckBoxDialog confirmDlg = new VWAdminConfirmWithCheckBoxDialog(this.m_parentFrame, dlgTitle, msg, checkBoxMsg, 0);
            confirmDlg.setVisible(true);
            if (confirmDlg.isCanceled()) {
                this.m_bCanceled = true;
                this.removeReferences();
                return;
            }
            this.m_bOverride = confirmDlg.isChecked();
        } else {
            VWAdminConfirmDialog confirmDlg = new VWAdminConfirmDialog(this.m_parentFrame, dlgTitle, msg, 0);
            confirmDlg.setVisible(true);
            if (confirmDlg.isCanceled()) {
                this.m_bCanceled = true;
                this.removeReferences();
                return;
            }
            this.m_bOverride = true;
        }
        this.processLock();
        this.removeReferences();
    }

    public VWAdminLockWork(VWAdminResultPane resultsPane) {
        this.init(resultsPane);
        if (this.m_logonUser == null) {
            JOptionPane.showMessageDialog(this.m_parentFrame, VWResource.s_undeterminedLogonUser, VWResource.s_lockWorkDialogTitle, 1, null);
            this.m_bCanceled = true;
            return;
        }
        if (this.m_resultsTable.getSelectedRows().length == 0) {
            JOptionPane.showMessageDialog(resultsPane.getParentFrame(), VWResource.s_noRowSelected, VWResource.s_lockWorkDialogTitle, 1, null);
            return;
        }
        this.buildWobsList(this.m_selectedRows);
        if (VWAdminCommon.isAnyLockedByOthers(this.m_wobsList)) {
            VWAdminConfirmDialog dlg = new VWAdminConfirmDialog(this.m_parentFrame, VWResource.s_lockTitle, VWResource.s_confirmOverride, 0);
            dlg.setVisible(true);
            if (dlg.isCanceled()) {
                this.m_bCanceled = true;
                this.removeReferences();
                return;
            }
            this.m_bOverride = dlg.isYes();
        } else {
            this.m_bOverride = true;
        }
        this.processLock();
        this.removeReferences();
    }

    protected boolean getReturnStatus() {
        return this.m_bCanceled;
    }

    protected Vector getWorkItemsList() {
        return this.m_wobsList;
    }

    private void processLock() {
        this.doLock();
        this.m_tableModel.refreshSelectedRows(this.m_selectedRows);
        if (this.m_vErrors.size() != 0) {
            VWAdminErrorsDialog dlg = new VWAdminErrorsDialog(this.m_parentFrame, VWResource.s_lockTitle, VWResource.s_lockErr, this.m_vErrors);
            dlg.setVisible(true);
            this.m_bCanceled = true;
            return;
        }
    }

    private void init(VWAdminResultPane resultsPane) {
        this.m_resultsPane = resultsPane;
        this.m_selectedRows = this.m_resultsPane.getSelectedRows();
        this.m_tableModel = this.m_resultsPane.getTableModel();
        this.m_resultsTable = this.m_resultsPane.getResultsTable();
        this.m_listSelectionModel = this.m_resultsTable.getSelectionModel();
        this.m_logonUser = this.m_resultsPane.getLogonUser();
        this.m_mainContainer = this.m_resultsPane.getMainContainer();
        this.m_parentFrame = this.m_resultsPane.getParentFrame();
    }

    private void buildWobsList(int[] rows) {
        try {
            for (int i = 0; i < rows.length; ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_tableModel.getObjectAt(rows[i]);
                this.m_wobsList.addElement(woData);
                VWAdminCommon.addChildrenToWobsList(woData.getChildren(), false, this.m_wobsList);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void doLock() {
        VWWorkObject[] woArray = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        VWException[] arrayExceptions = null;
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
        if (this.m_tableModel instanceof VWAdminWOInRosterTableModel) {
            for (int i = 0; i < this.m_wobsList.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
                if (woData.getLockedStatus() == 1) continue;
                VWWorkObject wob = woData.getWob();
                try {
                    wob.doLock(this.m_bOverride);
                    wob.doRefresh(true, true);
                    woData.updateLockedInfo();
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, ex);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
        } else {
            int i;
            int i2;
            for (i2 = 0; i2 < this.m_wobsList.size(); ++i2) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i2);
                int lockedStatus = woData.getLockedStatus();
                if (woData.getLockedStatus() == 1) continue;
                woVector.addElement(woData.getWob());
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i2 = 0; i2 < woVector.size(); ++i2) {
                    woArray[i2] = (VWWorkObject)woVector.elementAt(i2);
                }
                try {
                    VWWorkObject curWorkObject = woArray[0];
                    arrayExceptions = VWWorkObject.doLockMany(woArray, this.m_bOverride);
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            } else {
                return;
            }
            for (i = 0; i < woArray.length; ++i) {
                VWWorkObject wob = woArray[i];
                try {
                    if (arrayExceptions[i] == null) {
                        wob.doRefresh(true, true);
                        VWAdminWorkObjectTableData woData = VWAdminCommon.findWoData(wob, this.m_wobsList);
                        if (woData == null) continue;
                        woData.updateLockedInfo();
                        continue;
                    }
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(arrayExceptions[i]);
                    continue;
                }
                catch (Exception ex) {
                    VWAdminErrorDataObj errObj = new VWAdminErrorDataObj(wob, arrayExceptions[i]);
                    this.m_vErrors.addElement(errObj);
                    VWDebug.logException(ex);
                }
            }
            if (arrayExceptions != null) {
                for (i = 0; i < arrayExceptions.length; ++i) {
                    arrayExceptions[i] = null;
                }
            }
            if (woArray != null) {
                for (i = 0; i < woArray.length; ++i) {
                    woArray[i] = null;
                }
            }
            if (woVector != null) {
                woVector.removeAllElements();
            }
        }
    }

    private void selectWobs() {
        if (this.m_wobsList.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_wobsList.size(); ++i) {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_wobsList.elementAt(i);
            int rowIndex = woData.getRowIndex();
            if (woData.getLockedStatus() != 1 || rowIndex < 0) continue;
            this.m_listSelectionModel.addSelectionInterval(rowIndex, rowIndex);
        }
    }

    private void removeReferences() {
        if (this.m_vErrors != null) {
            this.m_vErrors.removeAllElements();
        }
    }
}

